$(document).ready(function(){

    tablaPersonas = $("#tablaPersonas").DataTable({

       "columnDefs":[{

        "targets": -1,

        "data":null,

        "defaultContent": "<div class='text-center'><div class='btn-group'><button class='btn btn-primary btnEditar'>Editar</button><button class='btn btn-danger btnBorrar'>Koha</button></div></div>"
       }],

       "pageLength": 50,
       "order": [ 1, "asc" ],
       "bPaginate": true,
       "bInfo" : true,
       "dom": 'Bfrtip',
        "buttons": [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ],
        "fixedHeader": true,

    "language": {

            "lengthMenu": "Mostrar _MENU_ registros",

            "zeroRecords": "No se encontraron resultados",

            "info": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",

            "infoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",

            "infoFiltered": "(filtrado de un total de _MAX_ registros)",

            "sSearch": "Buscar:",

            "oPaginate": {

                "sFirst": "Primero",

                "sLast":"Último",

                "sNext":"Siguiente",

                "sPrevious": "Anterior"

             },

             "sProcessing":"Procesando...",

        }

    });

    // Prevenir cierre del navegador al ejecutar un script
    var hook = false;
    window.onbeforeunload = function(){
        console.log('Intento de cierre de ventana o recarga');
        if (hook) {
            return "Did you save your stuff?";
        }
    };
    function b_hook(bol) {
        hook=bol;
    }
    

$("#btnNuevo").click(function(){

    $("#formCarreras").trigger("reset");

    $(".modal-header").css("background-color", "#1cc88a");

    $(".modal-header").css("color", "white");

    $(".modal-title").text("Nueva Carrera");            

    $("#carreras").modal("show");        

    id=null;

    opcion = 1; //alta

});    

    

var fila; //capturar la fila para editar o borrar el registro

//botón Importar Estudiantes y doc/no doc
$(document).on("click", ".btnImportar", function(){
    var txtBtn = $(this).text();
    $(".modal-header").css("background-color", "#4e73df");
    $(".modal-header").css("color", "white");
    $(".modal-title").text(txtBtn);            
    $("#modalImportar").modal("show");

    id=null;
    opcion = $(this).data('opcion');; //Importar
}); 

//botón EDITAR
$(document).on("click", ".btnEditar", function(){
    fila = $(this).closest("tr");
    id = parseInt(fila.data('id'));
    dni = parseInt(fila.find('#td_dni').text());
    nombre = fila.find('#td_nombre').text();
    email = fila.find('#td_email').text();
    telefono = fila.find('#td_tel').text();
    condicion = fila.find('#td_cond').text();
    estado = fila.find('#td_estado').text();
    carrera = fila.find('#td_carrera').text();
    carrerasCod = $("#td_carrerasCod[data-id='"+dni+"']").val();

    data_cond = fila.data('cond');

    $("#id_persona").val(id);
    $("#dni").val(dni);
    $("#dni_orig").val(dni);
    $("#nombre").val(nombre);
    $("#email").val(email);
    $("#telefono").val(telefono);
    $("#condicion").val(condicion);
    $("#estado").val(estado);
    $("#carreras_cod").val(carrerasCod);

    $("#data_cond").val(data_cond);

    opcion = 2; //editar

    $(".modal-header").css("background-color", "#60c0f8bb");
    if (data_cond=='docente') {
        $(".modal-header").css("background-color", "#5bf3a7c9");
    }
    $(".modal-header").css("color", "white");
    $(".modal-title").text("Editar");            
    $("#modalCRUD").modal("show");
});



//botón BORRAR
$(document).on("click", ".btnBorrar", function(){    

    fila = $(this);

    id = parseInt($(this).closest("tr").find('td:eq(0)').text());

    opcion = 3 //borrar

    var respuesta = confirm("¿Está seguro de eliminar el registro: "+id+"?");

    if(respuesta){

        $.ajax({

            url: "bd/crud.php",

            type: "POST",

            dataType: "json",

            data: {opcion:opcion, id:id},

            success: function(){

                tablaPersonas.row(fila.parents('tr')).remove().draw();

            }

        });

    }   

});

    
// Actualizar Estudiante y docentes
$("#formPersonas").submit(function(e){
    e.preventDefault();    

    var formData = new FormData(document.getElementById("formPersonas"));
    formData.append("opcion", opcion);

    $.ajax({
        url: "bd/crud.php",
        type: "POST",
        dataType: "json",
        data: formData,
        processData: false,
        contentType: false,
        success: function(data){  
            console.log(data);

            dni = data[0].nro_documento; 
            nombre = data[0].nombre
            email = data[0].email;
            telefono = data[0].telefono;
            condicion = data[0].condicion;
            estado = data[0].estado;
            carreraCodigos = data.carr_cod;
            carreraNombres = data.carr_nombre;

            $.fn.dataTable.ext.errMode = 'none';

            if(opcion == 1){
                tablaPersonas.row.add([nombre,apellido,email]).draw();
            }else{
                tablaPersonas.row(fila).data([dni,nombre,email,telefono,condicion,estado,carreraNombres]).draw();
                $("#td_carrerasCod[data-id='"+dni+"']").val(carreraCodigos);
            }            
        },
        error: function(xhr, textStatus, errorThrown){
            alert('\t\tError\n'+xhr.responseText); 
        } 
    });
    $(this).trigger("reset");
    $("#td_carrerasCod[data-id='"+dni+"']").val('');
    $("#modalCRUD").modal("hide"); 
});



$("#formCarreras").submit(function(e){

    e.preventDefault();    

    nombre = $.trim($("#nombree").val());

    codigo = $.trim($("#codigo").val()); 

    opcion = 1 //agregar carrera

    $.ajax({

        url: "bd/crud.php",

        type: "POST",

        dataType: "json",

        data: {nombre:nombre, codigo:codigo, opcion:opcion},

        success: function(data){  

            console.log(data);

        }        

    });

    $("#carreras").modal("hide");    
}); 

    
// Importar Estudiantes
$("#formImportar").submit(function(e){
    e.preventDefault();    

    var ts = $(this);

    $('.progress-bar').removeClass('bg-success');
    $('.progress-bar').removeClass('bg-danger');
    $('.progress-bar').removeClass('progress-bar-striped');
    $('.progress-bar').html('');

    var file_data = $('#fileImp').prop('files')[0];   

    var formData = new FormData(document.getElementById("formImportar"));
    formData.append("opcion", opcion);

    $.ajax({
        url: "bd/crud.php",
        type: "POST",
        dataType: "json",
        data: formData,
        cache: false,
        contentType: false,
	    processData: false,
        xhr: function() {
            var xhr = $.ajaxSettings.xhr();
            xhr.upload.onprogress = function(e) {
                console.log(Math.floor(e.loaded / e.total *100) + '%');
                $('.progress-bar').width(Math.floor(e.loaded / e.total *100) + '%');
            };
            return xhr;
        },
        beforeSend: function beforeSend(n) {
            $('.progress').removeClass('d-none');
            $('.progress-bar').addClass('progress-bar-striped');
            // $('.progress-bar').width('100%');
            $('.progress-bar').html('Guardando...');00000000000000000000000
            b_hook(true);
        },
        error: function error(xhr, ajaxOptions, thrownError) {
            console.log("Result: " + xhr.responseText);
            $('.progress-bar').addClass('bg-danger');
            $('.progress-bar').html('Error');
            $('.progress-bar').width('100%');
            b_hook(false);
            window.onbeforeunload = null;
            alert('Error\n\t'+xhr.responseText);
        }
    }).done(function(data){  
        console.log('Correcto');
        console.log(data);
        $('.progress-bar').html(data.texto);
        $('.progress-bar').addClass('bg-success');

    }).always(function () {
        $('.progress-bar').removeClass('progress-bar-striped');
        b_hook(false);
        window.onbeforeunload = null;
        setTimeout(function () {
            $('.progress').addClass('d-none');
            $('.progress-bar').html('');
            location.reload();
        }, 3000);
        ts[0].reset();
    });

    $("#modalImportar").modal("hide");    
}); 


});