<?php require_once "vistas/parte_superior.php"?>

<!--INICIO del cont principal-->
<div class="container">
   <center> <h1>Bienvenido al sistema - Padrón UNLPam</h1></center>
    
    
    
 <?php
include_once 'bd/conexion.php';
$objeto = new Conexion();
$conexion = $objeto->Conectar();

// Union de base de daros de docentes
$un_doc = "";

// Datos paginación
$pag_limit = '15'; // Limite de resultados por página
$resultado_t = $conexion->prepare("SELECT nro_documento, carrera_cargo FROM estudiantes GROUP BY nro_documento UNION ALL
SELECT nro_documento, cargo FROM docentesynd GROUP BY nro_documento");
$resultado_t->execute() or die($resultado_t->errorInfo()[2]);
$res_tot=$resultado_t->rowCount();

$pageNum = isset($_GET['pg']) ? intval($_GET['pg']) : 1;
$pageNum_sel = ($pageNum>0) ? ($pageNum-1)*$pag_limit : 0;
if ($pageNum_sel > $res_tot || $pageNum < 1) {
    $pageNum_sel=0;$pageNum = 1;
}
$num_pages = ceil($res_tot / $pag_limit); // Cantidad de paginas

// Consulta a la base de datos
$cons_est = "nombre, tipo_documento, nro_documento, sexo, domicilio_procedencia, localidad_procedencia, provincia_procedencia, pais_procedencia, telefono_procedencia, domicilio, localidad, telefono, email, condicion, estado, pertenencia, GROUP_CONCAT(carrera_cargo SEPARATOR ', ') as carrera_cargo, dedicacion, fecha_cancelacion, carrera_cargo as carr_nom, 'estudiante'";
$cons_doc = "apellido AS nombre, tipo_documento, nro_documento, sexo, domicilio_procedencia, localidad_procedencia, provincia_procedencia, pais_procedencia, telefono_procedencia, domicilio, localidad, telefono, email, condicion, estado, pertenencia, cargo AS carrera_cargo, dedicacion, fecha_cancelacion, cargo as carr_nom, 'docente'";

$consulta = "SELECT $cons_est FROM estudiantes LEFT JOIN (SELECT GROUP_CONCAT(nombre SEPARATOR ', ') AS car_nom2, codigo FROM carreras GROUP BY codigo) as carreras ON FIND_IN_SET(carreras.codigo, carrera_cargo) != 0 GROUP BY nro_documento UNION ALL
SELECT $cons_doc FROM docentesynd GROUP BY nro_documento ORDER BY nombre ASC limit $pageNum_sel, $pag_limit";

$resultado = $conexion->prepare($consulta);
$resultado->execute() or die($resultado->errorInfo()[2]);
$data=$resultado->fetchAll(PDO::FETCH_ASSOC);
?>


<div class="container-xxl w-100">
    <div class="row" >
        <div class="col-lg-auto">            
        <button id="btnNuevo" type="button" class="btn btn-success" data-toggle="modal">Agregar nueva carrera</button>    
        </div>   
        <div class="col-lg-auto pl-0">            
        <button id="btnImportarEst" type="button" class="btn btn-primary btnImportar" data-opcion="4" data-toggle="modal">Importar Estudiantes</button>    
        </div>
        <div class="col-lg-auto pl-0">            
        <button id="btnImportarDoc" type="button" class="btn btn-success btnImportar" data-opcion="5"  data-toggle="modal">Importar Docentes / No Docentes</button>    
        </div>
    </div> 
    <div class="progress mt-3 d-none">
        <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="" aria-valuemin="0" aria-valuemax="100"></div>
    </div> 
</div> 

<br> 




<div class="container-xxl w-100">
    <div class="row">
        <div class="col-lg-12">
            <div class="table-responsive">        
                <table id="tablaPersonas" class="table table-striped table-bordered table-condensed" style="width:100%">
                    <thead class="text-center">
                        <tr>
                            <th>Dni</th>
                            <th>Nombre</th>
                            <th>Email</th>     
                            <th>Tel.</th>                         
                            <th>Condición</th>  
                            <th>Estado</th>
                            <th>Carreras</th>
                            <th>Acción</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php                            
                        foreach($data as $dat) {    
                            $cond_tipo = $dat['estudiante'];
                            $options_tr = 'data-id="'.$dat['nro_documento'].'" data-cond="'.$cond_tipo.'" class="cond_'.$cond_tipo.'"';
                        
                            $carrera_ = trim($dat['carrera_cargo']);
                            $carrera_ = array_map('trim', array_unique(explode(', ',$carrera_)));
                            $carrera = implode(", ",$carrera_);

                            $carr_nom = $carrera;
                            if ($cond_tipo=='estudiante') {
                                $carr_nom = '';
                                $carr_nom_cant = count($carrera_);
                                // Buscar el nombre de la carrera segun los códigos
                                for ($i=0; $i < $carr_nom_cant; $i++) { 
                                    $coma_carr = $carr_nom_cant-1 == $i ? '' : ', '; // Separación
                                    $cod_num = $carrera_[$i];
                                    $res_cod_num = $conexion->prepare("SELECT nombre, codigo FROM carreras WHERE codigo = $cod_num");
                                    $res_cod_num->execute() or die($res_cod_num->errorInfo()[2]);
                                    $data_cod_num=$res_cod_num->fetchAll(PDO::FETCH_ASSOC); 
                                    $carr_nom_bd = $data_cod_num[0]['nombre'];   
                                    if ($carr_nom_bd=='') $carr_nom_bd='Sin Definir'; // Mensaje si el código no existe
                                    $carr_nom .= $carr_nom_bd.$coma_carr;
                                }
                            }
                        ?>
                        <tr <?php echo $options_tr ?>>
                            <td id="td_dni"><?php echo $dat['nro_documento'] ?></td>
                            <td id="td_nombre"><?php echo $dat['nombre']?></td>
                            <td id="td_email" style="overflow:hidden; max-width:200px;text-overflow: ellipsis;" title="<?php echo $dat['email'] ?>"><?php echo $dat['email'] ?></td>
                            <td id="td_tel"><?php echo $dat['telefono'] ?></td>
                            <td id="td_cond"><?php echo $dat['condicion'] ?></td>
                            <td id="td_estado"><?php echo $dat['estado'] ?></td> 
                            <td id="td_carrera"><?php echo $carr_nom ?></td>
                            <td></td>
                        </tr>

                        <!-- Oculto -->
                        <div class="d-none">
                            <input type="hidden" id="td_carrerasCod" name="td_carrerasCod" data-id="<?php echo $dat['nro_documento'] ?>" value="<?php echo $carrera ?>">
                        </div>
                        <?php
                            }
                        ?>                                
                    </tbody>        
                </table> 
                <div class="container pl-0 pr-0 mt-2">
                    <div class="row align-items-baseline m-0">
                        <div class="col-sm p-0">
                            <div class="dataTables_info">
                                Mostrando registros del <?php echo $pageNum_sel ?> al <?php echo $pageNum_sel+$pag_limit ?> de un total de <?php echo $res_tot ?> registros   
                            </div>
                        </div>
                        <div class="col-sm p-0 <?php echo $num_pages>1 ? '' : 'd-none' ?>">
                            <div class="dataTables_paginate paging_simple_numbers">
                                <ul class="pagination justify-content-md-end">
                                    <li class="page-item"><a class="page-link" href="?pg=<?php echo $pageNum > 1 ? $pageNum-1 : ''?>">Atras</a></li>
                                    <?php
                                        $limit_pagination = 5;
                                        $counter = 1;
                                        $link_pag = "";
                                        for ($i=1;$i<=$num_pages;$i++) {
                                            $class_active = '';
                                            if ($i == $pageNum) {
                                                $class_active = 'active';
                                            }

                                            if ($i == $pageNum-2 && $i > 1) {
                                                $link_pag .= '<li class="page-item"><a class="page-link">...</a></li>';
                                            }
                                            if ($i < 2 || ($i<$limit_pagination+$pageNum && $i>$pageNum-2) || $i>$num_pages-1) {
                                                $link_pag .= '<li class="page-item '.$class_active.'"><a class="page-link" href="?pg='.$i.'">'.$i.'</a></li>'; 
                                            }
                                            if ($i == $pageNum+$limit_pagination && $i < $num_pages) {
                                                $link_pag .= '<li class="page-item"><a class="page-link">...</a></li>';
                                            }
                                        }

                                        echo $link_pag;
                                    ?>
                                    <li class="page-item"><a class="page-link" href="?pg=<?php echo $pageNum < $num_pages ? $pageNum+1 : '' ?>">Siguiente</a></li>
                                </ul>
                            </div> 
                        </div>
                    </div>      
                </div>
                 
            </div>
        </div>
    </div> 
</div>    
      
<!--Modal para EDITAR estudiantes y docentes-->
<div class="modal fade" id="modalCRUD" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="formPersonas">    
                <div class="modal-body">
                    <div class="form-group">
                    <label for="dni" class="col-form-label">Dni:</label>
                    <input type="text" class="form-control" id="dni" name="dni">
                    </div>
                    <div class="form-group">
                    <label for="nombre" class="col-form-label">Apellido y Nombre:</label>
                    <input type="text" class="form-control" id="nombre" name="nombre" autocomplete="off">
                    </div>
                    <div class="form-group">
                    <label for="email" class="col-form-label">Email:</label>
                    <input type="text" class="form-control" id="email" name="email" autocomplete="off">
                    </div>     
                    <div class="form-group">
                    <label for="telefono" class="col-form-label">Teléfono:</label>
                    <input type="text" class="form-control" id="telefono" name="telefono" autocomplete="off">
                    </div>     
                    <div class="form-group">
                    <label for="condicion" class="col-form-label">Condición:</label>
                    <input type="text" class="form-control" id="condicion" name="condicion" autocomplete="off">
                    </div>     
                    <div class="form-group">
                    <label for="estado" class="col-form-label">Estado:</label>
                    <input type="text" class="form-control" id="estado" name="estado" autocomplete="off">
                    </div>     
                    <div class="form-group">
                    <label for="carreras_cod" class="col-form-label">Carrera / Cargo:</label>
                    <input type="text" class="form-control" id="carreras_cod" name="carreras_cod" autocomplete="off">
                    </div>     

                    <input type="hidden" id="id_persona" name="id_persona" value="" autocomplete="off">    
                    <input type="hidden" id="data_cond" name="data_cond" value="" autocomplete="off">
                    <input type="hidden" id="dni_orig" name="dni_orig" value="" autocomplete="off">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-dismiss="modal">Cancelar</button>
                    <button type="submit" id="btnGuardar" class="btn btn-dark">Guardar</button>
                </div>
            </form>    
        </div>
    </div>
</div> 

<!--Modal para IMPORTAR Estudiantes y doc/no doc-->
<div class="modal fade" id="modalImportar" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form enctype="multipart/form-data" id="formImportar" method="post">    
                <div class="modal-body">
                    <div class="form-group">
                    <label for="fileImp" class="col-form-label">Selecciona un archivo:</label>
                    <input type="file" class="form-control" id="fileImp" name="fileImp" accept=".doc,.docx,.csv,.xlsx,.xls,.xlsm,.txt,.xml" autocomplete="off">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-dismiss="modal">Cancelar</button>
                    <button type="submit" id="btnGuardar" class="btn btn-dark">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>  
      
<!--Modal para CRUD-->
<div class="modal fade" id="carreras" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
            </div>
        <form id="formCarreras">    
            <div class="modal-body">
                <div class="form-group">
                <label for="nombree" class="col-form-label">Nombre de la carrera:</label>
                <input type="text" class="form-control" id="nombree">
                </div>
                <div class="form-group">
                <label for="codigo" class="col-form-label">Código:</label>
                <input type="text" class="form-control" id="codigo">
                </div>                            
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-dismiss="modal">Cancelar</button>
                <button type="submit" id="btnGuardar" class="btn btn-dark">Guardar</button>
            </div>
        </form>    
        </div>
    </div>
</div>    
    
</div>



<!--FIN del cont principal-->
<?php require_once "vistas/parte_inferior.php"?>

