<?php
error_reporting(E_ALL ^ E_WARNING);

include_once '../bd/conexion.php';

$objeto = new Conexion();

$conexion = $objeto->Conectar();

// Para limpiar caracteres especiales y comillas
function clear_chars($var, $estricto=false){
    $limpiar = array('\\');
    if ($estricto) {  $limpiar = array('"','\'','\\','/'); }

    $var = str_replace($limpiar,'',$var);
    $final = htmlspecialchars(trim($var), ENT_QUOTES);
    return $final;
}

// Recepción de los datos enviados mediante POST desde el JS   
$id = (isset($_POST['id_persona'])) ? clear_chars($_POST['id_persona']) : '';
$dni = (isset($_POST['dni'])) ? clear_chars($_POST['dni']) : '';
$dni_orig = (isset($_POST['dni_orig'])) ? clear_chars($_POST['dni_orig']) : '';
$nombre = (isset($_POST['nombre'])) ? clear_chars($_POST['nombre']) : '';
$email = (isset($_POST['email'])) ? clear_chars($_POST['email']) : '';
$telefono = (isset($_POST['telefono'])) ? clear_chars($_POST['telefono']) : '';
$condicion = (isset($_POST['condicion'])) ? clear_chars($_POST['condicion']) : '';
$estado = (isset($_POST['estado'])) ? clear_chars($_POST['estado']) : '';
$carrera = (isset($_POST['carreras_cod'])) ? clear_chars($_POST['carreras_cod']) : '';
$codigo = (isset($_POST['codigo'])) ? clear_chars($_POST['codigo']) : '';


$data_cond = (isset($_POST['data_cond'])) ? clear_chars($_POST['data_cond']) : ''; // Obtengo si es docente o estudiante

$opcion = (isset($_POST['opcion'])) ? intval($_POST['opcion']) : '';


switch($opcion){

    case 1: //alta

        $consulta = "INSERT INTO carreras (codigo, nombre) VALUES('$codigo', '$nombre') ";			

        $resultado = $conexion->prepare($consulta);

        $resultado->execute(); 

        $data=array('texto' => 'Carrera cargada correctamente');

        break;

    case 2: //modificación
        
        if ($data_cond=="estudiante") {
            // Actualización de Estudiantes
            $consulta = "UPDATE estudiantes SET nro_documento='$dni', nombre='$nombre', email='$email', telefono='$telefono', estado='$estado', condicion='$condicion', carrera_cargo='$carrera' WHERE nro_documento='$dni_orig'";		
            $resultado = $conexion->prepare($consulta);
            $resultado->execute();

            // Buscar el nombre de la carrera segun los códigos
                $carrera_ = array_map('trim', array_unique(explode(', ',$carrera)));
                $carr_nom_cant = count($carrera_);

                $carr_nom = '';
                for ($i=0; $i < $carr_nom_cant; $i++) { 
                    $coma_carr = $carr_nom_cant-1 == $i ? '' : ', '; // Separación
                    $cod_num = $carrera_[$i];
                    $res_cod_num = $conexion->prepare("SELECT nombre, codigo FROM carreras WHERE codigo = $cod_num");
                    $res_cod_num->execute() or die($res_cod_num->errorInfo()[2]);
                    $data_cod_num=$res_cod_num->fetchAll(PDO::FETCH_ASSOC); 
                    $carr_nom_bd = $data_cod_num[0]['nombre'];   
                    if ($carr_nom_bd=='') $carr_nom_bd='Sin Definir'; // Mensaje si el código no existe
                    $carr_nom .= $carr_nom_bd.$coma_carr;
                }

            $consulta = "SELECT *, GROUP_CONCAT(carrera_cargo SEPARATOR ', ') as carrera_cargo
            FROM estudiantes WHERE nro_documento='$dni' GROUP BY nro_documento";
        }else {
            // Actualización de Docentes
            $consulta = "UPDATE docentesynd SET nro_documento='$dni', apellido='$nombre', email='$email', telefono='$telefono', estado='$estado', condicion='$condicion', cargo='$carrera' WHERE nro_documento='$dni_orig'";		
            $resultado = $conexion->prepare($consulta);
            $resultado->execute();

            $carr_nom = $carrera;
            $consulta = "SELECT *, apellido AS nombre, cargo as carrera_cargo
            FROM docentesynd WHERE nro_documento='$dni' GROUP BY nro_documento";
        }


        // Carga valores almacenados
        $resultado = $conexion->prepare($consulta);
        $resultado->execute();   
        $data=$resultado->fetchAll(PDO::FETCH_ASSOC)+['carr_nombre'=>$carr_nom]+['carr_cod'=>$carrera]; 
        break;        

    case 3://baja

        $consulta = "DELETE FROM personas2 WHERE id='$id' ";		

        $resultado = $conexion->prepare($consulta);

        $resultado->execute();                           

        break;        
    
    case 4: // Importar estudiantes
        $file = fopen($_FILES['fileImp']['tmp_name'], 'r') or exit('File not found');

        $members = array();
        $datami = array( );

        $data = "";
        $sum = 0;
        while ($line = utf8_encode(fgets($file))) {
            $sum++;

            if ($sum>1) { // Tomo los datos a partir de la segunda linea
                // Crear array de datos
                $data_txt = str_getcsv($line, "\t"); // Separa por tab
                $members[] = $data_txt;
                $cantidad = count($data_txt);

                if ($cantidad>16) {
                    // Variables
                    $nombre = clear_chars($data_txt[0],1);
                    $tipo_documento = clear_chars($data_txt[1]);
                    $nro_documento = clear_chars($data_txt[2],1);
                    $sexo = clear_chars($data_txt[3]);
                    $domicilio_proc = clear_chars($data_txt[4]);
                    $localidad_proc = clear_chars($data_txt[5]);
                    $provincia_proc = clear_chars($data_txt[6]);
                    $pais_proc = clear_chars($data_txt[7]);
                    $telefono_proc = clear_chars($data_txt[8]);
                    $domicilio = clear_chars($data_txt[9]);
                    $localidad = clear_chars($data_txt[10]);
                    $telefono = clear_chars($data_txt[11],1);
                    $email = clear_chars($data_txt[12]);
                    $condicion = clear_chars($data_txt[13]);
                    $estado = clear_chars($data_txt[14]);
                    $pertenencia = clear_chars($data_txt[15]);
                    $carrera_cargo = clear_chars($data_txt[16],1);
                    $dedicacion = clear_chars($data_txt[17]);
                    $fecha_cancelacion = clear_chars($data_txt[18]);   

                    // Inserto los las variables a la BD
                    $consulta = "INSERT IGNORE INTO estudiantes 
                    (nombre, tipo_documento, nro_documento, sexo, domicilio_procedencia, localidad_procedencia, provincia_procedencia, pais_procedencia, telefono_procedencia, domicilio, localidad, telefono, email, condicion, estado, pertenencia, carrera_cargo, dedicacion, fecha_cancelacion) VALUES
                    ('$nombre', '$tipo_documento', '$nro_documento', '$sexo', '$domicilio_proc', '$localidad_proc', '$provincia_proc', '$pais_proc', '$telefono_proc', '$domicilio', '$localidad', '$telefono', '$email', '$condicion', '$estado', '$pertenencia', '$carrera_cargo', '$dedicacion', '$fecha_cancelacion') ";			

                    $resultado = $conexion->prepare($consulta);

                    $resultado->execute() or exit($resultado->errorInfo()[2]);    

                    flush();
                    ob_flush();
                }else {
                    echo 'El archivo no contiene las columnas necesarias';
                    exit;
                }
            }
        }

        $data=array('texto' => 'Archivo guardado correctamente ');
        fclose($file);

        if ($data=='') {
            echo 'Se ha producido un error a la hora de almacenar el archivo';
            exit;
        }

    break;

    case 5: // Importar docentes y no doc
        $members = array();

        $data = "";
        $sum = 0;
        $lineas = file($_FILES['fileImp']['tmp_name']) or exit('File not found');

        foreach ($lineas as $num_linea => $linea) {
            $sum++;
            // $linea = utf8_encode($linea);

            // Variables
            $apellido=clear_chars(substr($linea,0,40),1); 
            $tipo_documento=clear_chars(substr($linea,40,3),1); 
            $nro_documento=clear_chars(substr($linea, 44, 8),1); 
            $sexo=clear_chars(substr($linea,52,1)); 
            $domicilio_procedencia=clear_chars(substr($linea, 53, 40)); 
            $localidad_procedencia=clear_chars(substr($linea, 93, 4)); 
            $provincia_procedencia=clear_chars(substr($linea, 97, 1)); 
            $país_procedencia=clear_chars(substr($linea, 98, 2)); 
            $telefono_procedencia=clear_chars(substr($linea,101,15),1); 
            $domicilio=""; 
            $localidad=""; 
            $telefono= ""; 
            $email=clear_chars(substr($linea,120,39)); 
            $condicion=clear_chars(substr($linea,160,1)); 
            $estado=clear_chars(substr($linea,161,1)); 
            $pertenencia=clear_chars(substr($linea, 162, 4)) ; 
            $carrera=""; 
            $cargo=clear_chars(substr($linea, 170, 3),1); 
            $dedicacion=clear_chars(substr($linea,174,3)); 
            $fecha_cancelacion=clear_chars(substr($linea,177,8)); 

            // Inserto los las variables a la BD
            $consulta = "INSERT IGNORE INTO docentesynd 
            (apellido, tipo_documento, nro_documento, sexo, domicilio_procedencia, localidad_procedencia, provincia_procedencia, pais_procedencia, telefono_procedencia, domicilio, localidad, telefono, email, condicion, estado, pertenencia, carrera, cargo, dedicacion, fecha_cancelacion) VALUES
            ('$apellido', '$tipo_documento', '$nro_documento', '$sexo', '$domicilio_procedencia', '$localidad_procedencia', '$provincia_procedencia', '$país_procedencia', '$telefono_procedencia', '$domicilio', '$localidad', '$telefono', '$email', '$condicion', '$estado', '$pertenencia', '$carrera', '$cargo', '$dedicacion', '$fecha_cancelacion') ";			

            $resultado = $conexion->prepare($consulta);

            $resultado->execute() or exit($resultado->errorInfo()[2]);  

            // $members[] = $apellido;
        }

        $data=array('texto' => 'Archivo guardado correctamente ');

        if ($data=='') {
            echo 'Se ha producido un error a la hora de almacenar el archivo';
            exit;
        }
    break;
}



print json_encode($data, JSON_UNESCAPED_UNICODE); //enviar el array final en formato json a JS

$conexion = NULL;

