<?php
require_once "config/database_singleton.php";

try {
    $db = getDB('jade');
    
    // Obtener estadísticas del día
    $fecha = date('Y-m-d');
    
    // Contar total de cuentas y obtener estadísticas del día
    $query = "SELECT 
                (SELECT COUNT(DISTINCT login) FROM accounts) as total_cuentas,
                COUNT(DISTINCT a.login) as total_logins,
                COUNT(DISTINCT a.lastip) as ips_unicas
              FROM accounts a 
              WHERE DATE(a.last_active) = CURRENT_DATE";
    
    $stmt = $db->query($query);
    $stats = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Validar y ajustar datos
    $total_logins = max(0, $stats['total_logins']);
    $ips_unicas = max(0, $stats['ips_unicas']);
    
    // Insertar o actualizar estadísticas
    $query = "INSERT INTO account_stats (
                fecha, 
                total_cuentas, 
                total_logins, 
                ips_unicas
              ) VALUES (
                :fecha, 
                :total_cuentas, 
                :total_logins, 
                :ips_unicas
              ) ON DUPLICATE KEY UPDATE 
                total_cuentas = :total_cuentas,
                total_logins = :total_logins,
                ips_unicas = :ips_unicas";
                
    $stmt = $db->prepare($query);
    $stmt->execute([
        ':fecha' => $fecha,
        ':total_cuentas' => $stats['total_cuentas'],
        ':total_logins' => $total_logins,
        ':ips_unicas' => $ips_unicas
    ]);
    
    echo "Estadísticas actualizadas exitosamente para " . $fecha;
    
} catch(PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>




