<?php
session_start();
if(!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

require_once "config/database_singleton.php";
require_once "includes/password_utils.php";

// Conexión a la base de datos Jade
$db = getDB('jade');

try {
    // Obtener cuentas con sus contraseñas
    $query = "SELECT login, password FROM accounts";
    $stmt = $db->query($query);
    $accounts = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Intentar desencriptar las contraseñas
    $passwords_found = 0;
    $accounts_with_passwords = [];
    
    foreach($accounts as $account) {
        $decrypted = decryptPasswordAttempt($account['password']);
        if($decrypted !== false) {
            $passwords_found++;
            $accounts_with_passwords[] = [
                'login' => $account['login'],
                'encrypted' => $account['password'],
                'decrypted' => $decrypted
            ];
        }
    }

} catch(PDOException $e) {
    $error = "Error al obtener datos: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CRM - Análisis de Contraseñas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background-color: #343a40;
            padding-top: 20px;
        }
        .sidebar a {
            color: white;
            text-decoration: none;
            padding: 10px 15px;
            display: block;
        }
        .sidebar a:hover {
            background-color: #495057;
        }
        .main-content {
            padding: 20px;
        }
        .table th {
            background-color: #343a40;
            color: white;
        }
        .stat-card {
            background-color: white;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-2 sidebar">
                <h3 class="text-white text-center mb-4">CRM Panel</h3>
                <a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a>
                <a href="clientes.php"><i class="fas fa-users"></i> Clientes</a>
                <a href="accounts.php"><i class="fas fa-user-circle"></i> Accounts</a>
                <a href="duplicados.php"><i class="fas fa-copy"></i> Duplicados</a>
                <a href="passwords.php" class="active"><i class="fas fa-key"></i> Contraseñas</a>
                <a href="interacciones.php"><i class="fas fa-comments"></i> Interacciones</a>
                <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Cerrar Sesión</a>
            </div>

            <!-- Main Content -->
            <div class="col-md-10 main-content">
                <h2 class="mb-4">Análisis de Contraseñas</h2>

                <?php if(isset($error)): ?>
                    <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>

                <!-- Resumen -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="stat-card">
                            <h4>Total de Contraseñas Identificadas</h4>
                            <h2><?php echo number_format($passwords_found, 0, ',', '.'); ?></h2>
                            <p class="text-muted mb-0">De un total de <?php echo number_format(count($accounts), 0, ',', '.'); ?> cuentas</p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="stat-card">
                            <h4>Porcentaje Identificado</h4>
                            <h2><?php echo number_format(($passwords_found / count($accounts)) * 100, 1); ?>%</h2>
                            <p class="text-muted mb-0">Del total de cuentas</p>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <?php if(!empty($accounts_with_passwords)): ?>
                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th>Usuario</th>
                                            <th>Contraseña Encriptada</th>
                                            <th>Contraseña Real</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach($accounts_with_passwords as $account): ?>
                                            <tr>
                                                <td><?php echo htmlspecialchars($account['login']); ?></td>
                                                <td><code><?php echo htmlspecialchars($account['encrypted']); ?></code></td>
                                                <td><strong><?php echo htmlspecialchars($account['decrypted']); ?></strong></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-info">
                                No se pudieron identificar contraseñas con el método actual.
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
