<?php
/**
 * Monitor de Conexiones Optimizadas
 * Script para monitorear el rendimiento de las conexiones después de la optimización
 */

require_once "config/database_singleton.php";

echo "=== MONITOR DE CONEXIONES OPTIMIZADAS ===\n\n";

// Obtener estadísticas actuales
$stats = getDBStats();

echo "ESTADO ACTUAL DE CONEXIONES:\n";
echo "============================\n";
echo "Conexión CRM activa: " . ($stats['crm_connected'] ? '✅ SÍ' : '❌ NO') . "\n";
echo "Conexión Jade activa: " . ($stats['jade_connected'] ? '✅ SÍ' : '❌ NO') . "\n";
echo "Total de conexiones: " . $stats['total_connections'] . "\n\n";

// Probar conexiones
echo "PRUEBA DE CONEXIONES:\n";
echo "====================\n";

try {
    $db_crm = getDB('crm');
    echo "✅ Conexión CRM establecida correctamente\n";
    
    // Probar consulta simple
    $stmt = $db_crm->query("SELECT 1 as test");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "✅ Consulta CRM ejecutada correctamente\n";
    
} catch (Exception $e) {
    echo "❌ Error en conexión CRM: " . $e->getMessage() . "\n";
}

try {
    $db_jade = getDB('jade');
    echo "✅ Conexión Jade establecida correctamente\n";
    
    // Probar consulta simple
    $stmt = $db_jade->query("SELECT 1 as test");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "✅ Consulta Jade ejecutada correctamente\n";
    
} catch (Exception $e) {
    echo "❌ Error en conexión Jade: " . $e->getMessage() . "\n";
}

// Verificar que las conexiones son las mismas (singleton)
echo "\nVERIFICACIÓN SINGLETON:\n";
echo "======================\n";

$db_crm_1 = getDB('crm');
$db_crm_2 = getDB('crm');
$db_jade_1 = getDB('jade');
$db_jade_2 = getDB('jade');

if ($db_crm_1 === $db_crm_2) {
    echo "✅ Conexiones CRM son la misma instancia (Singleton funcionando)\n";
} else {
    echo "❌ Conexiones CRM son diferentes (Singleton NO funciona)\n";
}

if ($db_jade_1 === $db_jade_2) {
    echo "✅ Conexiones Jade son la misma instancia (Singleton funcionando)\n";
} else {
    echo "❌ Conexiones Jade son diferentes (Singleton NO funciona)\n";
}

// Obtener estadísticas finales
$final_stats = getDBStats();
echo "\nESTADÍSTICAS FINALES:\n";
echo "=====================\n";
echo "Total de conexiones después de pruebas: " . $final_stats['total_connections'] . "\n";
echo "Conexión CRM activa: " . ($final_stats['crm_connected'] ? 'SÍ' : 'NO') . "\n";
echo "Conexión Jade activa: " . ($final_stats['jade_connected'] ? 'SÍ' : 'NO') . "\n";

// Comparación con el sistema anterior
echo "\nCOMPARACIÓN CON SISTEMA ANTERIOR:\n";
echo "=================================\n";
echo "Sistema anterior: 36 conexiones totales (19 CRM + 17 Jade)\n";
echo "Sistema optimizado: " . $final_stats['total_connections'] . " conexiones totales\n";
echo "Reducción: " . (36 - $final_stats['total_connections']) . " conexiones menos\n";
echo "Porcentaje de optimización: " . round(((36 - $final_stats['total_connections']) / 36) * 100, 2) . "%\n";

echo "\n✅ OPTIMIZACIÓN COMPLETADA EXITOSAMENTE\n";
echo "Las conexiones ahora se manejan de manera eficiente usando el patrón Singleton.\n";
?>
