<?php
session_start();
if(isset($_SESSION['user_id'])) {
    header("Location: dashboard.php");
    exit();
}

require_once "config/database_singleton.php";

$error = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $db = getDB('crm');
    
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if (!empty($username) && !empty($password)) {
        $query = "SELECT id, username, password, nombre_completo FROM usuarios WHERE username = ? AND activo = 1";
        $stmt = $db->prepare($query);
        $stmt->execute([$username]);
        
        if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            // Usar la misma codificación que la tabla accounts
            $pass_encrypt = base64_encode(pack("H*", sha1(utf8_encode($password))));
            if ($pass_encrypt === $row['password']) {
                $_SESSION['user_id'] = $row['id'];
                $_SESSION['username'] = $row['username'];
                $_SESSION['nombre_completo'] = $row['nombre_completo'];
                
                // Update last login
                $updateQuery = "UPDATE usuarios SET ultimo_login = NOW() WHERE id = ?";
                $updateStmt = $db->prepare($updateQuery);
                $updateStmt->execute([$row['id']]);
                
                header("Location: dashboard.php");
                exit();
            } else {
                $error = "Contraseña incorrecta";
            }
        } else {
            $error = "Usuario no encontrado";
        }
    } else {
        $error = "Por favor complete todos los campos";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CRM - Login</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/dark-theme.css" rel="stylesheet">
    <style>
        body {
            background-color: #1a1a1a;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .login-container {
            max-width: 400px;
            width: 100%;
            padding: 40px;
            background-color: #2d2d2d;
            border-radius: 12px;
            box-shadow: 0 8px 24px rgba(0,0,0,0.4);
            border: 1px solid #404040;
        }
        .login-container h2 {
            color: #ffffff;
            text-align: center;
            margin-bottom: 30px;
            font-weight: 600;
        }
        .form-label {
            color: #b0b0b0;
            font-weight: 500;
        }
        .form-control {
            background-color: #2d2d2d;
            border: 1px solid #404040;
            color: #e0e0e0;
            border-radius: 8px;
            padding: 12px 16px;
        }
        .form-control:focus {
            background-color: #353535;
            border-color: #0d6efd;
            color: #ffffff;
            box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
        }
        .btn-primary {
            background-color: #0d6efd;
            border-color: #0d6efd;
            border-radius: 8px;
            padding: 12px;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        .btn-primary:hover {
            background-color: #0b5ed7;
            border-color: #0a58ca;
            transform: translateY(-1px);
        }
        .alert-danger {
            background-color: #2c0b0e;
            border-color: #5c1a1b;
            color: #f1aeb5;
            border-radius: 8px;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <h2>CRM Login</h2>
        <?php if($error): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>
        <form method="POST" action="">
            <div class="mb-3">
                <label for="username" class="form-label">Usuario</label>
                <input type="text" class="form-control" id="username" name="username" required>
            </div>
            <div class="mb-3">
                <label for="password" class="form-label">Contraseña</label>
                <input type="password" class="form-control" id="password" name="password" required>
            </div>
            <button type="submit" class="btn btn-primary w-100">Iniciar Sesión</button>
        </form>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
