<?php
session_start();
if(!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

require_once "config/database_singleton.php";

$db = getDB('crm');
$db_jade = getDB('jade');

// Obtener estadísticas básicas
$stats = [
    'total_accounts' => 0,
    'logins_hoy_cuentas' => 0,
    'logins_hoy_ips' => 0,
    'promedio_cuentas_por_ip' => 0,
    'cuentas_hoy' => 0,
    'cuentas_ayer' => 0,
    'cuentas_semana' => 0,
    'cuentas_mes' => 0,
    'new_accounts_today' => 0,
    'new_accounts_week' => 0,
    'new_accounts_month' => 0
];

// Obtener estadísticas de la base de datos Jade
try {
    // Obtener datos actuales en tiempo real
    $query = "SELECT COUNT(DISTINCT login) as total FROM accounts";
    $stmt = $db_jade->query($query);
    $stats['total_accounts'] = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

    // Obtener logins del día actual (solo una cuenta por IP)
    $query = "SELECT 
                COUNT(DISTINCT lastip) as ips_unicas,
                COUNT(DISTINCT lastip) as cuentas_unicas_por_ip
              FROM accounts 
              WHERE DATE(last_active) = CURRENT_DATE";
    $stmt = $db_jade->query($query);
    $current_stats = $stmt->fetch(PDO::FETCH_ASSOC);
    
    $stats['logins_hoy_cuentas'] = $current_stats['cuentas_unicas_por_ip'];
    $stats['logins_hoy_ips'] = $current_stats['ips_unicas'];

    // Obtener el registro más reciente de account_stats
    $query = "SELECT total_cuentas, fecha 
              FROM account_stats 
              ORDER BY fecha DESC 
              LIMIT 1";
    $stmt = $db_jade->query($query);
    $last_record = $stmt->fetch(PDO::FETCH_ASSOC);
    

    
    // Usar los datos de account_stats que sabemos que funcionan
    $ultimo_total_general = 38759; // Total general del 2025-08-20
    $ultimo_total_logins = 1856;   // Logins del 2025-08-20 (cuentas con IP)
    
    // Contar total actual de cuentas con IP
    $query_total_con_ip = "SELECT COUNT(DISTINCT login) as total_con_ip 
                           FROM accounts 
                           WHERE lastip IS NOT NULL AND lastip != ''";
    $stmt_total = $db_jade->query($query_total_con_ip);
    $total_con_ip = $stmt_total->fetch(PDO::FETCH_ASSOC)['total_con_ip'];
    
    // Calcular diferencia usando el total general
    $cuentas_nuevas_general = $stats['total_accounts'] - $ultimo_total_general;
    
    // Pero tomar solo las que tienen IP de esas cuentas nuevas
    $cuentas_nuevas_con_ip = min($cuentas_nuevas_general, $total_con_ip - $ultimo_total_logins);
    
    // Forzar asignación de valores para debug
    $stats['ultimo_registro'] = $ultimo_total_general;
    $stats['ultimo_registro_logins'] = $ultimo_total_logins;
    $stats['fecha_ultimo_registro'] = '2025-08-21';
    $stats['cuentas_nuevas_brutas'] = $cuentas_nuevas_con_ip;
    $stats['total_con_ip'] = $total_con_ip;
    
    if ($cuentas_nuevas_con_ip > 0) {
        // Obtener las últimas N cuentas y contar solo IPs que no existían antes
        try {
            $query = "SELECT COUNT(DISTINCT nuevas.lastip) as ips_nuevas
                      FROM (
                          SELECT lastip 
                          FROM accounts 
                          WHERE lastip IS NOT NULL AND lastip != ''
                          ORDER BY id DESC 
                          LIMIT " . intval($cuentas_nuevas_con_ip) . "
                      ) as nuevas
                      WHERE nuevas.lastip NOT IN (
                          SELECT DISTINCT lastip 
                          FROM accounts 
                          WHERE lastip IS NOT NULL AND lastip != ''
                          AND id <= (SELECT MAX(id) - " . intval($cuentas_nuevas_con_ip) . " FROM accounts WHERE lastip IS NOT NULL AND lastip != '')
                      )";
            $stmt = $db_jade->query($query);
            $new_ips = $stmt->fetch(PDO::FETCH_ASSOC);
            
            $stats['new_accounts_today'] = $new_ips['ips_nuevas'] ?? 0;
        } catch (PDOException $e) {
            $stats['new_accounts_today'] = 0;
        }
    } else {
        $stats['new_accounts_today'] = 0;
    }
    
    // Calcular promedio de cuentas por IP
    if ($stats['logins_hoy_ips'] > 0) {
        $stats['promedio_cuentas_por_ip'] = round($stats['logins_hoy_cuentas'] / $stats['logins_hoy_ips'], 2);
    }

    // Obtener el registro más reciente de account_stats
    $query = "SELECT 
                total_cuentas,
                total_logins,
                ips_unicas,
                fecha
              FROM account_stats 
              ORDER BY fecha DESC 
              LIMIT 1";
    $stmt = $db_jade->query($query);
    $yesterday_stats = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($yesterday_stats) {
        $stats['cuentas_ayer'] = $yesterday_stats['total_cuentas'];
        $stats['logins_ayer'] = $yesterday_stats['total_logins'];
        $stats['ips_ayer'] = $yesterday_stats['ips_unicas'];
        $stats['fecha_referencia'] = $yesterday_stats['fecha'];
    } else {
        $stats['cuentas_ayer'] = 0;
        $stats['logins_ayer'] = 0;
        $stats['ips_ayer'] = 0;
        $stats['fecha_referencia'] = 'Sin datos';
    }

    // Calcular crecimiento semanal (últimos 7 días)
    $query = "SELECT total_cuentas 
              FROM account_stats 
              WHERE fecha = DATE_SUB(CURRENT_DATE, INTERVAL 7 DAY)
              ORDER BY fecha DESC 
              LIMIT 1";
    $stmt = $db_jade->query($query);
    $week_ago = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($week_ago) {
        $stats['cuentas_semana'] = $stats['total_accounts'] - $week_ago['total_cuentas'];
    } else {
        // Si no hay datos de hace 7 días, calcular usando MIN/MAX de la semana disponible
        $query = "SELECT 
                    MAX(total_cuentas) - MIN(total_cuentas) as crecimiento
                  FROM account_stats 
                  WHERE fecha >= DATE_SUB(CURRENT_DATE, INTERVAL 7 DAY)";
        $stmt = $db_jade->query($query);
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $stats['cuentas_semana'] = $result['crecimiento'] ?? 0;
    }

    // Calcular crecimiento mensual (últimos 30 días)
    $query = "SELECT total_cuentas 
              FROM account_stats 
              WHERE fecha = DATE_SUB(CURRENT_DATE, INTERVAL 30 DAY)
              ORDER BY fecha DESC 
              LIMIT 1";
    $stmt = $db_jade->query($query);
    $month_ago = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($month_ago) {
        $stats['cuentas_mes'] = $stats['total_accounts'] - $month_ago['total_cuentas'];
    } else {
        // Si no hay datos de hace 30 días, calcular usando MIN/MAX del mes disponible
        $query = "SELECT 
                    MAX(total_cuentas) - MIN(total_cuentas) as crecimiento
                  FROM account_stats 
                  WHERE fecha >= DATE_SUB(CURRENT_DATE, INTERVAL 30 DAY)";
        $stmt = $db_jade->query($query);
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $stats['cuentas_mes'] = $result['crecimiento'] ?? 0;
    }

    // Calcular promedio diario del mes
    if ($stats['cuentas_mes'] > 0) {
        $stats['promedio_diario'] = round($stats['cuentas_mes'] / 30, 1);
    } else {
        $stats['promedio_diario'] = 0;
    }
} catch(PDOException $e) {
    // Manejar error silenciosamente
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CRM - Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="assets/css/dark-theme.css" rel="stylesheet">
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-2 sidebar">
                <h3 class="text-white text-center mb-4">CRM Panel</h3>
                <a href="dashboard.php" class="active"><i class="fas fa-home"></i> Dashboard</a>
                <a href="accounts.php"><i class="fas fa-user-circle"></i> Accounts</a>
                <a href="characters.php"><i class="fas fa-gamepad"></i> Personajes</a>
                <a href="geolocalizacion.php"><i class="fas fa-globe"></i> Geolocalización</a>
                <?php if (isset($_SESSION['username']) && $_SESSION['username'] === 'jade'): ?>
                <a href="donations.php"><i class="fas fa-hand-holding-usd"></i> Donaciones</a>
                <?php endif; ?>
                <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Cerrar Sesión</a>
            </div>

            <!-- Main Content -->
            <div class="col-md-10 main-content">
                <h2 class="mb-4">Bienvenido, <?php echo htmlspecialchars($_SESSION['nombre_completo']); ?></h2>
                

                
                <!-- Estadísticas -->
                <div class="row mb-4">
                    <!-- Estadísticas generales -->
                    <div class="col-md-3">
                        <div class="stat-card text-center">
                            <h4>Total Cuentas</h4>
                            <h2><?php echo number_format($stats['total_accounts'], 0, ',', '.'); ?></h2>
                            <p class="text-muted mb-0">Cuentas únicas registradas</p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="stat-card text-center">
                            <h4>Actividad Hoy</h4>
                            <h2><?php echo number_format($stats['logins_hoy_ips'], 0, ',', '.'); ?></h2>
                            <p class="text-muted mb-0">IPs únicas activas</p>
                            <div class="mt-2">
                                <span class="badge bg-info">
                                    1 cuenta por IP única
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="stat-card text-center">
                            <h4>Nuevas Cuentas Hoy</h4>
                            <h2><?php echo number_format($stats['new_accounts_today'], 0, ',', '.'); ?></h2>
                            <p class="text-muted mb-0">
                                <?php 
                                if ($stats['new_accounts_today'] > 0) {
                                    echo "<span class='text-success'><i class='fas fa-plus'></i> Con IPs únicas</span>";
                                } else {
                                    echo "<span class='text-muted'>Sin cuentas nuevas con IPs únicas</span>";
                                }
                                ?>
                            </p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="stat-card text-center">
                            <h4>Resumen de Crecimiento</h4>
                            <div class="d-flex justify-content-between align-items-center">
                                <small class="text-muted">Últimos 7 días:</small>
                                <strong><?php echo number_format($stats['cuentas_semana'], 0, ',', '.'); ?></strong>
                            </div>
                            <div class="d-flex justify-content-between align-items-center mt-2">
                                <small class="text-muted">Últimos 30 días:</small>
                                <strong><?php echo number_format($stats['cuentas_mes'], 0, ',', '.'); ?></strong>
                            </div>
                            <p class="text-muted mb-0 mt-2">
                                <i class="fas fa-chart-line"></i> 
                                Promedio diario: <?php echo number_format($stats['promedio_diario'], 1, ',', '.'); ?>
                            </p>
                        </div>
                    </div>
                </div>



                <!-- Gráfico de tendencia -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">Tendencia de Creación de Cuentas</h5>
                                <div class="row h-100">
                                    <div class="col-md-6 d-flex flex-column">
                                        <h6 class="text-muted mb-3">Último registro (<?php echo $stats['fecha_referencia']; ?>)</h6>
                                        <div class="d-flex justify-content-between mb-2">
                                            <div>
                                                <small class="text-muted">Total Cuentas:</small>
                                                <strong><?php echo number_format($stats['cuentas_ayer'], 0, ',', '.'); ?></strong>
                                            </div>
                                        </div>
                                        <div class="mt-2">
                                            <small class="text-muted">Cuentas Activas:</small>
                                            <strong><?php echo number_format($stats['logins_ayer'], 0, ',', '.'); ?></strong>
                                        </div>
                                    </div>
                                    <div class="col-md-6 d-flex flex-column border-start border-2" style="border-color: #505050 !important;">
                                        <h6 class="text-muted mb-3 ps-3">Hoy</h6>
                                        <div class="d-flex justify-content-between mb-2 ps-3">
                                            <div>
                                                <small class="text-muted">Total Cuentas:</small>
                                                <strong><?php echo number_format($stats['total_accounts'], 0, ',', '.'); ?></strong>
                                            </div>
                                        </div>
                                        <div class="mt-2 ps-3">
                                            <small class="text-muted">Cuentas Activas:</small>
                                            <strong><?php echo number_format($stats['logins_hoy_cuentas'], 0, ',', '.'); ?></strong>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Menú de Acceso Rápido -->
                <h3 class="mb-4">Acceso Rápido</h3>
                <div class="row">
                    <!-- Accounts -->
                    <div class="col-md-3 mb-4">
                        <a href="accounts.php" class="menu-card">
                            <i class="fas fa-user-circle"></i>
                            <h4>Accounts</h4>
                            <p>Gestiona las cuentas del sistema</p>
                        </a>
                    </div>
                    
                    <!-- Personajes -->
                    <div class="col-md-3 mb-4">
                        <a href="characters.php" class="menu-card">
                            <i class="fas fa-gamepad"></i>
                            <h4>Personajes</h4>
                            <p>Gestiona los personajes del juego</p>
                        </a>
                    </div>

                    <!-- Herramientas de Monitoreo -->
                    <div class="col-md-3 mb-4">
                        <a href="herramientas_monitoreo.php" class="menu-card">
                            <i class="fas fa-tools"></i>
                            <h4>Monitoreo</h4>
                            <p>Herramientas de monitoreo y gestión</p>
                        </a>
                    </div>

                    <!-- Donaciones -->
                    <?php if (isset($_SESSION['username']) && $_SESSION['username'] === 'jade'): ?>
                    <div class="col-md-3 mb-4">
                        <a href="donations.php" class="menu-card">
                            <i class="fas fa-hand-holding-usd"></i>
                            <h4>Donaciones</h4>
                            <p>Gestiona las donaciones y pagos</p>
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>