<?php
/**
 * Clase Singleton para manejo optimizado de conexiones de base de datos
 * Evita conexiones duplicadas y mejora el rendimiento
 */
class DatabaseManager {
    private static $instance = null;
    private $crmConnection = null;
    private $jadeConnection = null;
    private $connectionCount = 0;
    
    private function __construct() {}
    
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    /**
     * Obtiene conexión a la base de datos CRM
     */
    public function getCRMConnection() {
        if ($this->crmConnection === null) {
            try {
                $this->crmConnection = new PDO(
                    "mysql:host=localhost;dbname=innovadi_crm_panel",
                    "innovadi_jade",
                    "gY@HlRv7nVSL9*ry",
                    array(
                        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                        PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8"
                    )
                );
                $this->connectionCount++;
            } catch(PDOException $e) {
                error_log("Error de conexión CRM: " . $e->getMessage());
                throw new Exception("Error de conexión a la base de datos CRM");
            }
        }
        return $this->crmConnection;
    }
    
    /**
     * Obtiene conexión a la base de datos Jade
     */
    public function getJadeConnection() {
        if ($this->jadeConnection === null) {
            try {
                $this->jadeConnection = new PDO(
                    "mysql:host=localhost;dbname=innovadi_jade",
                    "innovadi_jade",
                    "gY@HlRv7nVSL9*ry",
                    array(
                        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                        PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8"
                    )
                );
                $this->connectionCount++;
            } catch(PDOException $e) {
                error_log("Error de conexión Jade: " . $e->getMessage());
                throw new Exception("Error de conexión a la base de datos Jade");
            }
        }
        return $this->jadeConnection;
    }
    
    /**
     * Cierra todas las conexiones activas
     */
    public function closeConnections() {
        if ($this->crmConnection !== null) {
            $this->crmConnection = null;
            $this->connectionCount--;
        }
        if ($this->jadeConnection !== null) {
            $this->jadeConnection = null;
            $this->connectionCount--;
        }
    }
    
    /**
     * Obtiene estadísticas de conexiones
     */
    public function getConnectionStats() {
        return [
            'crm_connected' => $this->crmConnection !== null,
            'jade_connected' => $this->jadeConnection !== null,
            'total_connections' => $this->connectionCount
        ];
    }
    
    /**
     * Verifica si una conexión está activa
     */
    public function isCRMConnected() {
        return $this->crmConnection !== null;
    }
    
    public function isJadeConnected() {
        return $this->jadeConnection !== null;
    }
}

// Función helper para obtener conexiones fácilmente
function getDB($type = 'crm') {
    $manager = DatabaseManager::getInstance();
    switch(strtolower($type)) {
        case 'jade':
            return $manager->getJadeConnection();
        case 'crm':
        default:
            return $manager->getCRMConnection();
    }
}

// Función helper para cerrar conexiones
function closeDB() {
    $manager = DatabaseManager::getInstance();
    $manager->closeConnections();
}

// Función helper para obtener estadísticas
function getDBStats() {
    $manager = DatabaseManager::getInstance();
    return $manager->getConnectionStats();
}
?>
