<?php
/**
 * Cerrar Conexiones Manualmente
 * Script para cerrar todas las conexiones de base de datos activas
 */

echo "=== CERRAR CONEXIONES MANUALMENTE ===\n\n";

echo "⚠️  ADVERTENCIA: Este script cerrará todas las conexiones activas\n";
echo "Asegúrate de que no hay operaciones en curso antes de continuar.\n\n";

// Incluir el sistema de gestión
require_once "config/database_advanced.php";

// Obtener estado inicial
$stats_inicial = getAdvancedDBStats();
echo "📊 ESTADO INICIAL:\n";
echo "==================\n";
echo "Conexión CRM: " . ($stats_inicial['crm_connected'] ? '🔴 ABIERTA' : '✅ CERRADA') . "\n";
echo "Conexión Jade: " . ($stats_inicial['jade_connected'] ? '🔴 ABIERTA' : '✅ CERRADA') . "\n";
echo "Total de conexiones: " . $stats_inicial['total_connections'] . "\n\n";

if ($stats_inicial['total_connections'] == 0) {
    echo "✅ No hay conexiones activas para cerrar.\n";
    echo "El sistema ya está en estado óptimo.\n";
    exit();
}

echo "🔧 CERRANDO CONEXIONES...\n";
echo "========================\n";

// Cerrar todas las conexiones
closeAdvancedDB();

// Verificar estado después del cierre
$stats_final = getAdvancedDBStats();

echo "📊 ESTADO FINAL:\n";
echo "================\n";
echo "Conexión CRM: " . ($stats_final['crm_connected'] ? '🔴 ABIERTA' : '✅ CERRADA') . "\n";
echo "Conexión Jade: " . ($stats_final['jade_connected'] ? '🔴 ABIERTA' : '✅ CERRADA') . "\n";
echo "Total de conexiones: " . $stats_final['total_connections'] . "\n\n";

if ($stats_final['total_connections'] == 0) {
    echo "✅ TODAS LAS CONEXIONES CERRADAS EXITOSAMENTE\n";
    echo "   - Conexiones cerradas: " . $stats_inicial['total_connections'] . "\n";
    echo "   - Estado actual: " . $stats_final['total_connections'] . " conexiones\n";
    echo "   - Memoria liberada\n";
} else {
    echo "⚠️  ALGUNAS CONEXIONES NO SE CERRARON:\n";
    echo "   - Conexiones antes: " . $stats_inicial['total_connections'] . "\n";
    echo "   - Conexiones después: " . $stats_final['total_connections'] . "\n";
    echo "   - Conexiones restantes: " . $stats_final['total_connections'] . "\n";
}

echo "\n🧹 LIMPIEZA ADICIONAL:\n";
echo "=====================\n";

// Intentar limpieza adicional
$cleaned = cleanupDBConnections(0); // Forzar limpieza inmediata
if ($cleaned > 0) {
    echo "✅ Se limpiaron $cleaned conexiones adicionales\n";
} else {
    echo "ℹ️ No se encontraron conexiones adicionales para limpiar\n";
}

echo "\n📝 LOGS DE CIERRE:\n";
echo "==================\n";
$logs = getDBLogs(5);
if (!empty($logs)) {
    foreach ($logs as $log) {
        $logData = json_decode($log, true);
        if ($logData && in_array($logData['action'], ['CLOSING', 'CLEANUP'])) {
            $timestamp = $logData['timestamp'];
            $type = $logData['type'];
            $action = $logData['action'];
            $message = $logData['message'];
            
            $actionIcon = ($action == 'CLOSING') ? '🔒' : '🧹';
            echo "$actionIcon [$timestamp] $type - $action: $message\n";
        }
    }
} else {
    echo "No hay logs de cierre disponibles.\n";
}

echo "\n🎯 VERIFICACIÓN FINAL:\n";
echo "=====================\n";

// Verificación final
$stats_verificacion = getAdvancedDBStats();
$health = checkDBHealth();

echo "Estado de conexiones:\n";
foreach ($health as $type => $status) {
    $icon = $status['status'] === 'healthy' ? '✅' : ($status['status'] === 'unhealthy' ? '❌' : '⚠️');
    echo "$icon $type: " . strtoupper($status['status']) . "\n";
}

echo "\n📊 RESUMEN:\n";
echo "===========\n";
echo "Conexiones antes: " . $stats_inicial['total_connections'] . "\n";
echo "Conexiones después: " . $stats_verificacion['total_connections'] . "\n";
echo "Conexiones cerradas: " . ($stats_inicial['total_connections'] - $stats_verificacion['total_connections']) . "\n";

if ($stats_verificacion['total_connections'] == 0) {
    echo "\n✅ OPERACIÓN COMPLETADA EXITOSAMENTE\n";
    echo "Todas las conexiones han sido cerradas correctamente.\n";
} else {
    echo "\n⚠️  OPERACIÓN PARCIALMENTE COMPLETADA\n";
    echo "Algunas conexiones pueden estar en uso activo.\n";
}

echo "\n📅 Fecha de cierre: " . date('Y-m-d H:i:s') . "\n";
echo "🔧 Estado: CONEXIONES CERRADAS\n\n";

echo "💡 CONSEJOS:\n";
echo "===========\n";
echo "1. Ejecuta este script cuando no haya operaciones activas\n";
echo "2. Monitorea regularmente con verificar_conexiones_abiertas.php\n";
echo "3. Considera implementar cierre automático en tus scripts\n";
echo "4. Usa el patrón singleton para evitar conexiones duplicadas\n";
?>
