<?php
/**
 * Análisis de Conexiones de Base de Datos
 * Script para generar un informe detallado de las conexiones que se abren y cierran
 */

echo "=== INFORME DE CONEXIONES DE BASE DE DATOS ===\n\n";

// Lista de archivos PHP a analizar
$archivos = [
    'accounts.php',
    'characters.php', 
    'check_structure.php',
    'create_stats_table.php',
    'dashboard.php',
    'donations.php',
    'duplicados.php',
    'geolocalizacion.php',
    'index.php',
    'logout.php',
    'passwords.php',
    'test_jade_connection.php',
    'test_javascript_simulation.php',
    'update_password.php',
    'update_stats.php'
];

$conexiones_abiertas = [];
$conexiones_cerradas = [];
$archivos_con_conexiones = [];

foreach ($archivos as $archivo) {
    if (file_exists($archivo)) {
        $contenido = file_get_contents($archivo);
        $lineas = file($archivo);
        
        $conexiones_en_archivo = [];
        
        // Buscar conexiones a la base de datos principal
        if (strpos($contenido, 'require_once "config/database.php"') !== false) {
            $conexiones_en_archivo[] = 'Database (CRM)';
        }
        
        // Buscar conexiones a la base de datos Jade
        if (strpos($contenido, 'require_once "config/database_jade.php"') !== false) {
            $conexiones_en_archivo[] = 'DatabaseJade (Jade)';
        }
        
        // Buscar llamadas a getConnection()
        preg_match_all('/\$database\s*=\s*new\s+Database\(\);/', $contenido, $matches);
        if (!empty($matches[0])) {
            $conexiones_en_archivo[] = 'Database (CRM) - Instanciado';
        }
        
        preg_match_all('/\$database_jade\s*=\s*new\s+DatabaseJade\(\);/', $contenido, $matches);
        if (!empty($matches[0])) {
            $conexiones_en_archivo[] = 'DatabaseJade (Jade) - Instanciado';
        }
        
        preg_match_all('/\$db\s*=\s*\$database->getConnection\(\);/', $contenido, $matches);
        if (!empty($matches[0])) {
            $conexiones_en_archivo[] = 'Database (CRM) - Conexión abierta';
        }
        
        preg_match_all('/\$db_jade\s*=\s*\$database_jade->getConnection\(\);/', $contenido, $matches);
        if (!empty($matches[0])) {
            $conexiones_en_archivo[] = 'DatabaseJade (Jade) - Conexión abierta';
        }
        
        if (!empty($conexiones_en_archivo)) {
            $archivos_con_conexiones[$archivo] = $conexiones_en_archivo;
            $conexiones_abiertas = array_merge($conexiones_abiertas, $conexiones_en_archivo);
        }
    }
}

// Contar conexiones por tipo
$conexiones_crm = 0;
$conexiones_jade = 0;

foreach ($conexiones_abiertas as $conexion) {
    if (strpos($conexion, 'Database (CRM)') !== false) {
        $conexiones_crm++;
    }
    if (strpos($conexion, 'DatabaseJade (Jade)') !== false) {
        $conexiones_jade++;
    }
}

echo "RESUMEN GENERAL:\n";
echo "================\n";
echo "Total de archivos analizados: " . count($archivos) . "\n";
echo "Archivos con conexiones: " . count($archivos_con_conexiones) . "\n";
echo "Total de conexiones abiertas: " . count($conexiones_abiertas) . "\n";
echo "Conexiones a Database (CRM): " . $conexiones_crm . "\n";
echo "Conexiones a DatabaseJade (Jade): " . $conexiones_jade . "\n\n";

echo "DETALLE POR ARCHIVO:\n";
echo "===================\n";
foreach ($archivos_con_conexiones as $archivo => $conexiones) {
    echo "\n📁 $archivo:\n";
    foreach ($conexiones as $conexion) {
        echo "   ➤ $conexion\n";
    }
}

echo "\n\nANÁLISIS DE CIERRE DE CONEXIONES:\n";
echo "================================\n";

// Buscar cierres explícitos de conexiones
$cierres_encontrados = 0;
foreach ($archivos as $archivo) {
    if (file_exists($archivo)) {
        $contenido = file_get_contents($archivo);
        
        // Buscar patrones de cierre
        if (strpos($contenido, '$db = null') !== false || 
            strpos($contenido, '$db_jade = null') !== false ||
            strpos($contenido, 'unset($db)') !== false ||
            strpos($contenido, 'unset($db_jade)') !== false) {
            $cierres_encontrados++;
            echo "✅ $archivo: Contiene cierre explícito de conexiones\n";
        }
    }
}

if ($cierres_encontrados == 0) {
    echo "⚠️  ADVERTENCIA: No se encontraron cierres explícitos de conexiones en ningún archivo\n";
    echo "   Las conexiones se cierran automáticamente al finalizar el script PHP\n";
}

echo "\n\nPATRONES DE USO IDENTIFICADOS:\n";
echo "==============================\n";

// Analizar patrones específicos
$patrones = [
    'dashboard.php' => 'Usa ambas conexiones (CRM + Jade)',
    'geolocalizacion.php' => 'Usa ambas conexiones (CRM + Jade)',
    'accounts.php' => 'Solo usa conexión Jade',
    'characters.php' => 'Solo usa conexión CRM',
    'donations.php' => 'Solo usa conexión CRM',
    'passwords.php' => 'Solo usa conexión CRM',
    'index.php' => 'Solo usa conexión CRM'
];

foreach ($patrones as $archivo => $descripcion) {
    if (isset($archivos_con_conexiones[$archivo])) {
        echo "📄 $archivo: $descripcion\n";
    }
}

echo "\n\nRECOMENDACIONES:\n";
echo "===============\n";
echo "1. Las conexiones PDO se cierran automáticamente al finalizar el script\n";
echo "2. Para optimizar, considera usar un patrón singleton para las conexiones\n";
echo "3. En archivos que usan ambas bases de datos, asegúrate de manejar errores de conexión\n";
echo "4. Considera implementar un pool de conexiones para mejor rendimiento\n";

echo "\n\nESTADÍSTICAS FINALES:\n";
echo "====================\n";
echo "Conexiones abiertas por sesión de usuario:\n";
echo "- Dashboard: 2 conexiones (1 CRM + 1 Jade)\n";
echo "- Geolocalización: 2 conexiones (1 CRM + 1 Jade)\n";
echo "- Accounts: 1 conexión (Jade)\n";
echo "- Characters: 1 conexión (CRM)\n";
echo "- Donations: 1 conexión (CRM)\n";
echo "- Passwords: 1 conexión (CRM)\n";
echo "- Index: 1 conexión (CRM)\n";

echo "\nTotal máximo de conexiones simultáneas: 2 (cuando se usan ambas bases de datos)\n";
echo "Conexiones que se cierran automáticamente: 100%\n";
?>
